/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.api.feature.EnumMode;
import doggytalents.client.screen.HeelByGroupScreen;
import doggytalents.client.screen.HeelByNameScreen;
import doggytalents.client.screen.WhistleScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DoggyBeamEntity;
import doggytalents.common.entity.ai.triggerable.DogGoBehindOwnerAction;
import doggytalents.common.entity.ai.triggerable.DogMoveToBedAction;
import doggytalents.common.talent.RoaringGaleTalent;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WhistleItem
extends Item {
    public WhistleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (world.f_46443_) {
                WhistleScreen.open();
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        byte id_mode = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("mode", 99)) {
            id_mode = stack.m_41783_().m_128445_("mode");
        }
        List dogsList = world.m_6443_(Dog.class, player.m_20191_().m_82377_(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.m_21830_((LivingEntity)player));
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        WhistleMode mode = WhistleMode.VALUES[id_mode];
        this.useMode(mode, dogsList, world, player, hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public void useMode(WhistleMode mode, List<Dog> dogsList, Level world, Player player, InteractionHand hand) {
        if (mode == null) {
            return;
        }
        switch (mode.getSound()) {
            case NONE: {
                break;
            }
            case LONG: {
                world.m_5594_(null, player.m_20183_(), (SoundEvent)DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + world.f_46441_.m_188501_() * 0.1f, 0.8f + world.f_46441_.m_188501_() * 0.2f);
                break;
            }
            case SHORT: {
                world.m_5594_(null, player.m_20183_(), (SoundEvent)DoggySounds.WHISTLE_SHORT.get(), SoundSource.PLAYERS, 0.6f + world.f_46441_.m_188501_() * 0.1f, 0.8f + world.f_46441_.m_188501_() * 0.2f);
            }
        }
        boolean successful = false;
        switch (mode) {
            case STAND: {
                if (world.f_46443_) {
                    return;
                }
                for (Dog dog : dogsList) {
                    dog.m_21839_(false);
                    dog.m_21573_().m_26573_();
                    dog.m_6710_(null);
                    if (dog.getMode() == EnumMode.WANDERING) {
                        dog.setMode(EnumMode.DOCILE);
                    }
                    successful = true;
                }
                if (successful) {
                    player.m_213846_((Component)Component.m_237115_((String)"dogcommand.come"));
                }
                return;
            }
            case HEEL: {
                if (world.f_46443_) {
                    return;
                }
                int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
                List<Dog> heel_list = dogsList.stream().filter(filter_dog -> {
                    if (filter_dog.m_21827_()) {
                        return false;
                    }
                    if (!filter_dog.getMode().shouldFollowOwner()) {
                        return false;
                    }
                    return filter_dog.m_20280_((Entity)filter_dog.m_269323_()) > 9.0;
                }).collect(Collectors.toList());
                if (max_heel_count > 0 && heel_list.size() > max_heel_count) {
                    Collections.sort(heel_list, new EntityUtil.Sorter((Entity)player));
                    heel_list = heel_list.subList(0, max_heel_count);
                }
                if (heel_list.isEmpty()) {
                    return;
                }
                DogUtil.dynamicSearchAndTeleportToOwnwerInBatch(world, heel_list, (LivingEntity)player, 3);
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                player.m_213846_((Component)Component.m_237115_((String)"dogcommand.heel"));
                return;
            }
            case STAY: {
                if (world.f_46443_) {
                    return;
                }
                for (Dog dog : dogsList) {
                    dog.m_21839_(true);
                    dog.m_21573_().m_26573_();
                    dog.m_6710_(null);
                    if (dog.getMode() == EnumMode.WANDERING) {
                        dog.setMode(EnumMode.DOCILE);
                    }
                    successful = true;
                }
                if (successful) {
                    player.m_213846_((Component)Component.m_237115_((String)"dogcommand.stay"));
                }
                return;
            }
            case OKAY: {
                if (world.f_46443_) {
                    return;
                }
                for (Dog dog : dogsList) {
                    successful = true;
                    dog.m_21573_().m_26573_();
                    dog.m_6710_(null);
                    dog.m_21839_(dog.m_21233_() / 2.0f >= dog.m_21223_());
                }
                if (successful) {
                    player.m_213846_((Component)Component.m_237115_((String)"dogcommand.ok"));
                }
                return;
            }
            case SHELPERD: {
                return;
            }
            case TACTICAL: {
                if (world.f_46443_) {
                    return;
                }
                DoggyBeamEntity doggyBeam = new DoggyBeamEntity(world, (LivingEntity)player);
                doggyBeam.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.0f, 1.0f);
                world.m_7967_((Entity)doggyBeam);
                return;
            }
            case ROAR: {
                RoaringGaleTalent.roar(dogsList, world, player);
                return;
            }
            case HEEL_BY_NAME: {
                if (world.f_46443_) {
                    HeelByNameScreen.open();
                }
                return;
            }
            case TO_BED: {
                if (dogsList.isEmpty()) {
                    return;
                }
                if (player.f_19853_.f_46443_) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    BlockPos bedPos;
                    noDogs = false;
                    if (!dog.readyForNonTrivialAction() || (bedPos = (BlockPos)dog.getBedPos((ResourceKey<Level>)player.f_19853_.m_46472_()).orElse(null)) == null || dog.m_20183_().equals((Object)bedPos) && dog.m_21825_() || !(dog.m_20238_(Vec3.m_82539_((Vec3i)bedPos)) < 400.0)) continue;
                    dog.triggerActionDelayed(2, new DogMoveToBedAction(dog, bedPos, false));
                }
                if (!noDogs) {
                    player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                }
                return;
            }
            case GO_BEHIND: {
                if (player.f_19853_.f_46443_) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    LivingEntity owner;
                    if (!dog.getMode().shouldFollowOwner() || (owner = dog.m_269323_()) == null || dog.m_20280_((Entity)owner) > 400.0) continue;
                    dog.m_6710_(null);
                    dog.clearTriggerableAction();
                    dog.triggerAction(new DogGoBehindOwnerAction(dog, owner));
                    noDogs = false;
                }
                if (!noDogs) {
                    player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                }
                return;
            }
            case HEEL_BY_GROUP: {
                if (world.f_46443_) {
                    HeelByGroupScreen.open();
                }
                return;
            }
        }
    }

    public String m_5671_(ItemStack stack) {
        byte mode = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("mode", 99)) {
            mode = stack.m_41783_().m_128445_("mode");
        }
        return this.m_5524_() + "." + mode;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public static enum WhistleMode {
        STAND(0, WhistleSound.LONG),
        HEEL(1, WhistleSound.LONG),
        STAY(2, WhistleSound.SHORT),
        OKAY(3, WhistleSound.LONG),
        SHELPERD(4, WhistleSound.SHORT),
        TACTICAL(5, WhistleSound.NONE),
        ROAR(6, WhistleSound.NONE),
        HEEL_BY_NAME(7, WhistleSound.NONE),
        TO_BED(8, WhistleSound.LONG),
        GO_BEHIND(9, WhistleSound.SHORT),
        HEEL_BY_GROUP(10, WhistleSound.NONE);

        public static final WhistleMode[] VALUES;
        private int id;
        private WhistleSound sound;

        private WhistleMode(int id, WhistleSound sound) {
            this.id = id;
            this.sound = sound;
        }

        public int getIndex() {
            return this.id;
        }

        public WhistleSound getSound() {
            return this.sound;
        }

        public String getUnlocalisedTitle() {
            return "item.doggytalents.whistle." + this.getIndex();
        }

        static {
            VALUES = (WhistleMode[])Arrays.stream(WhistleMode.values()).sorted(Comparator.comparingInt(WhistleMode::getIndex)).toArray(WhistleMode[]::new);
        }
    }

    public static enum WhistleSound {
        NONE,
        SHORT,
        LONG;

    }
}

