/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.client.entity.render.world.CanineTrackerLocateRenderer;
import doggytalents.client.screen.CanineTrackerScreen;
import doggytalents.common.item.CanineTrackerItem;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Triple;

public class CanineTrackerPackets {

    public static class ResponsePosUpdatePacket
    implements IPacket<CanineTrackerData.ResponsePosUpdateData> {
        @Override
        public void encode(CanineTrackerData.ResponsePosUpdateData data, FriendlyByteBuf buf) {
            buf.m_130077_(data.uuid);
            buf.m_130064_(data.correctPos);
        }

        @Override
        public CanineTrackerData.ResponsePosUpdateData decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            BlockPos pos = buf.m_130135_();
            return new CanineTrackerData.ResponsePosUpdateData(uuid, pos);
        }

        @Override
        public void handle(CanineTrackerData.ResponsePosUpdateData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
                if (!side.isClient()) {
                    return;
                }
                CanineTrackerLocateRenderer.correctPos(data.uuid, data.correctPos);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RequestPosUpdatePacket
    implements IPacket<CanineTrackerData.RequestPosUpdateData> {
        @Override
        public void encode(CanineTrackerData.RequestPosUpdateData data, FriendlyByteBuf buf) {
            buf.m_130077_(data.uuid);
            buf.m_130064_(data.pos);
        }

        @Override
        public CanineTrackerData.RequestPosUpdateData decode(FriendlyByteBuf buf) {
            return new CanineTrackerData.RequestPosUpdateData(buf.m_130259_(), buf.m_130135_());
        }

        @Override
        public void handle(CanineTrackerData.RequestPosUpdateData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
                if (!side.isServer()) {
                    return;
                }
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                ItemStack stack = sender.m_21205_();
                if (!(stack.m_41720_() instanceof CanineTrackerItem)) {
                    return;
                }
                DogLocationStorage storage = DogLocationStorage.get(sender.f_19853_);
                DogLocationData entry = storage.getData(data.uuid);
                if (entry == null) {
                    return;
                }
                UUID owner_id = entry.getOwnerId();
                if (owner_id == null) {
                    return;
                }
                if (!owner_id.equals(sender.m_20148_())) {
                    return;
                }
                Vec3 correct_pos = entry.getPos();
                if (correct_pos == null) {
                    return;
                }
                BlockPos correct_blockpos = new BlockPos(Mth.m_14107_((double)correct_pos.f_82479_), Mth.m_14107_((double)correct_pos.f_82480_), Mth.m_14107_((double)correct_pos.f_82481_));
                if (correct_blockpos.m_123331_((Vec3i)data.pos) < 4.0) {
                    return;
                }
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new CanineTrackerData.ResponsePosUpdateData(data.uuid, correct_blockpos));
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class StartLocatingPacket
    implements IPacket<CanineTrackerData.StartLocatingData> {
        @Override
        public void encode(CanineTrackerData.StartLocatingData data, FriendlyByteBuf buf) {
            buf.m_130077_(data.uuid);
            buf.m_130070_(data.name);
            buf.m_130064_(data.pos);
        }

        @Override
        public CanineTrackerData.StartLocatingData decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            String name = buf.m_130277_();
            BlockPos pos = buf.m_130135_();
            return new CanineTrackerData.StartLocatingData(uuid, name, pos);
        }

        @Override
        public void handle(CanineTrackerData.StartLocatingData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                CompoundTag tag;
                LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
                if (!side.isServer()) {
                    return;
                }
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                ItemStack stack = player.m_21205_();
                if (!(stack.m_41720_() instanceof CanineTrackerItem)) {
                    return;
                }
                if (!stack.m_41782_()) {
                    stack.m_41751_(new CompoundTag());
                }
                if ((tag = stack.m_41783_()) == null) {
                    return;
                }
                tag.m_128362_("uuid", data.uuid);
                tag.m_128359_("name", data.name);
                tag.m_128405_("posX", data.pos.m_123341_());
                tag.m_128405_("posY", data.pos.m_123342_());
                tag.m_128405_("posZ", data.pos.m_123343_());
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ResponseDogsPackets
    implements IPacket<CanineTrackerData.ResponseDogsData> {
        @Override
        public void encode(CanineTrackerData.ResponseDogsData data, FriendlyByteBuf buf) {
            int size = data.entries.size();
            buf.writeInt(size);
            for (int i = 0; i < size; ++i) {
                Triple<UUID, String, BlockPos> payload = data.entries.get(i);
                UUID uuid = (UUID)payload.getLeft();
                String name = (String)payload.getMiddle();
                BlockPos pos = (BlockPos)payload.getRight();
                if (uuid == null) {
                    uuid = Util.f_137441_;
                }
                if (name == null) {
                    name = "noname";
                }
                if (pos == null) {
                    pos = BlockPos.f_121853_;
                }
                buf.m_130077_(uuid);
                buf.m_130070_(name);
                buf.m_130064_(pos);
            }
        }

        @Override
        public CanineTrackerData.ResponseDogsData decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<Triple<UUID, String, BlockPos>> newDogsLs = new ArrayList<Triple<UUID, String, BlockPos>>(size);
            for (int i = 0; i < size; ++i) {
                UUID id = buf.m_130259_();
                String name = buf.m_130277_();
                BlockPos pos = buf.m_130135_();
                Triple payload = Triple.of((Object)id, (Object)name, (Object)pos);
                newDogsLs.add((Triple<UUID, String, BlockPos>)payload);
            }
            return new CanineTrackerData.ResponseDogsData(newDogsLs);
        }

        @Override
        public void handle(CanineTrackerData.ResponseDogsData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    Screen patt5006$temp;
                    Minecraft mc = Minecraft.m_91087_();
                    if (mc.f_91080_ != null && (patt5006$temp = mc.f_91080_) instanceof CanineTrackerScreen) {
                        CanineTrackerScreen scr = (CanineTrackerScreen)patt5006$temp;
                        scr.assignResponse(data.entries);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RequestDogsPacket
    implements IPacket<CanineTrackerData.RequestDogsData> {
        @Override
        public void encode(CanineTrackerData.RequestDogsData data, FriendlyByteBuf buf) {
        }

        @Override
        public CanineTrackerData.RequestDogsData decode(FriendlyByteBuf buf) {
            return new CanineTrackerData.RequestDogsData();
        }

        @Override
        public void handle(CanineTrackerData.RequestDogsData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
                if (!side.isServer()) {
                    return;
                }
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                DogLocationStorage storage = DogLocationStorage.get(sender.f_19853_);
                List<Triple<UUID, String, BlockPos>> dogLs = storage.getDogs((LivingEntity)sender, (ResourceKey<Level>)sender.f_19853_.m_46472_()).filter(dogLoc -> dogLoc.shouldDisplay(sender.f_19853_, (Player)sender, InteractionHand.MAIN_HAND)).map(dogLoc -> Triple.of((Object)dogLoc.getDogId(), (Object)dogLoc.getDogName(), (Object)new BlockPos(Mth.m_14107_((double)dogLoc.getPos().f_82479_), Mth.m_14107_((double)dogLoc.getPos().f_82480_), Mth.m_14107_((double)dogLoc.getPos().f_82481_)))).collect(Collectors.toList());
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new CanineTrackerData.ResponseDogsData(dogLs));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

