/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.ChangeAccessoriesData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ChangeAccessoryPacket
extends DogPacket<ChangeAccessoriesData> {
    @Override
    public void encode(ChangeAccessoriesData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
        buf.writeBoolean(data.add);
        buf.writeInt(data.slotId);
    }

    @Override
    public ChangeAccessoriesData decode(FriendlyByteBuf buf) {
        int dog_id = buf.readInt();
        boolean add = buf.readBoolean();
        int slot_id = buf.readInt();
        return new ChangeAccessoriesData(dog_id, add, slot_id);
    }

    @Override
    public void handleDog(Dog dog, ChangeAccessoriesData data, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        if (!dog.canInteract((LivingEntity)sender)) {
            return;
        }
        if (data.add) {
            Inventory inventory = sender.m_150109_();
            NonNullList items = inventory.f_35974_;
            if (data.slotId >= items.size()) {
                return;
            }
            ItemStack item = (ItemStack)items.get(data.slotId);
            Item item2 = item.m_41720_();
            if (item2 instanceof AccessoryItem) {
                AccessoryItem accessoryItem = (AccessoryItem)item2;
                AccessoryInstance inst = accessoryItem.createInstance(dog, item, (Player)sender);
                if (inst == null) {
                    return;
                }
                if (dog.addAccessory(inst)) {
                    dog.consumeItemFromStack((Entity)dog, item);
                }
            }
        } else {
            List<AccessoryInstance> accessories = dog.getAccessories();
            if (data.slotId >= accessories.size()) {
                return;
            }
            AccessoryInstance toRemove = accessories.get(data.slotId);
            if (toRemove == null) {
                return;
            }
            Inventory inventory = sender.m_150109_();
            ItemStack retItem = toRemove.getReturnItem();
            if (retItem == null) {
                return;
            }
            if (inventory.m_36062_() < 0) {
                return;
            }
            inventory.m_36054_(toRemove.getReturnItem());
            accessories.remove(toRemove);
            dog.markAccessoriesDirty();
        }
    }
}

