/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.CrossOriginTpData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class CrossOriginTpPacket
extends DogPacket<CrossOriginTpData> {
    @Override
    public void encode(CrossOriginTpData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeBoolean(data.crossOriginTp);
    }

    @Override
    public CrossOriginTpData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean crossOriginTp = buf.readBoolean();
        return new CrossOriginTpData(entityId, crossOriginTp);
    }

    @Override
    public void handleDog(Dog dogIn, CrossOriginTpData data, Supplier<NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        dogIn.setCrossOriginTp(data.crossOriginTp);
    }
}

