/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogSoftHeelAction;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.HeelByNameData;
import doggytalents.common.util.DogUtil;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class HeelByNamePacket
extends DogPacket<HeelByNameData> {
    @Override
    public void encode(HeelByNameData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
        buf.writeBoolean(data.heelAndSit);
        buf.writeBoolean(data.softHeel);
    }

    @Override
    public HeelByNameData decode(FriendlyByteBuf buf) {
        return new HeelByNameData(buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    @Override
    public void handleDog(Dog dog, HeelByNameData data, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer owner = ctx.get().getSender();
        if (!dog.canInteract((LivingEntity)owner)) {
            return;
        }
        if (owner.m_36335_().m_41519_((Item)DoggyItems.WHISTLE.get())) {
            return;
        }
        if (dog.m_20159_()) {
            dog.m_8127_();
        }
        dog.clearTriggerableAction();
        if (data.softHeel) {
            if (dog.readyForNonTrivialAction()) {
                dog.triggerAction(new DogSoftHeelAction(dog, (LivingEntity)owner));
            }
        } else {
            dog.m_21839_(data.heelAndSit);
            DogUtil.dynamicSearchAndTeleportToOwnwer(dog, (LivingEntity)owner, 2);
        }
        owner.f_19853_.m_5594_(null, owner.m_20183_(), (SoundEvent)DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + owner.f_19853_.f_46441_.m_188501_() * 0.1f, 0.4f + owner.f_19853_.f_46441_.m_188501_() * 0.2f);
        owner.m_213846_((Component)Component.m_237110_((String)"dogcommand.heel_by_name", (Object[])new Object[]{dog.m_7755_().getString()}));
        owner.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
        ItemStack stack = owner.m_21205_();
        if (stack.m_41720_() instanceof WhistleItem) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
                stack.m_41783_().m_128379_("soft_heel", data.softHeel);
            } else {
                stack.m_41783_().m_128379_("soft_heel", data.softHeel);
            }
        }
    }
}

