/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogEatingParticleData;
import doggytalents.common.network.packet.data.DogStartShakingLavaData;
import doggytalents.common.network.packet.data.ParticleData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ParticlePackets {

    public static class DogStartShakingLavaPacket
    implements IPacket<DogStartShakingLavaData> {
        @Override
        public void encode(DogStartShakingLavaData data, FriendlyByteBuf buf) {
            buf.writeInt(data.dogId);
        }

        @Override
        public DogStartShakingLavaData decode(FriendlyByteBuf buf) {
            int dogId = buf.readInt();
            return new DogStartShakingLavaData(dogId);
        }

        @Override
        public void handle(DogStartShakingLavaData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    Minecraft mc = Minecraft.m_91087_();
                    Entity e = mc.f_91073_.m_6815_(data.dogId);
                    if (e instanceof Dog) {
                        Dog d = (Dog)e;
                        d.startShakingLava();
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendDogStartShakingLavaPacketToNearByClients(AbstractDog dog) {
            int RADIUS = 64;
            PacketDistributor.TargetPoint tarp = new PacketDistributor.TargetPoint(dog.m_20185_(), dog.m_20186_(), dog.m_20189_(), 64.0, dog.f_19853_.m_46472_());
            PacketHandler.send(PacketDistributor.NEAR.with(() -> tarp), new DogStartShakingLavaData(dog.m_19879_()));
        }
    }

    public static class DogEatingParticlePacket
    implements IPacket<DogEatingParticleData> {
        @Override
        public void encode(DogEatingParticleData data, FriendlyByteBuf buf) {
            buf.writeInt(data.dogId);
            buf.m_130055_(data.food);
        }

        @Override
        public DogEatingParticleData decode(FriendlyByteBuf buf) {
            int dogId = buf.readInt();
            ItemStack food = buf.m_130267_();
            return new DogEatingParticleData(dogId, food);
        }

        @Override
        public void handle(DogEatingParticleData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    Minecraft mc = Minecraft.m_91087_();
                    Entity e = mc.f_91073_.m_6815_(data.dogId);
                    if (e != null && data.food != null) {
                        Entity dog = e;
                        float a1 = dog.m_146908_();
                        float dx1 = -Mth.m_14031_((float)(a1 * ((float)Math.PI / 180)));
                        float dz1 = Mth.m_14089_((float)(a1 * ((float)Math.PI / 180)));
                        for (int i = 0; i < 15; ++i) {
                            double d1 = mc.f_91073_.m_213780_().m_188583_() * 0.5;
                            double d3 = mc.f_91073_.m_213780_().m_188583_() * 0.8;
                            double d5 = mc.f_91073_.m_213780_().m_188583_() * 0.5;
                            double d6 = mc.f_91073_.m_213780_().m_188583_() * 0.1;
                            double d7 = mc.f_91073_.m_213780_().m_188583_() * 0.1;
                            double d8 = mc.f_91073_.m_213780_().m_188583_() * 0.1;
                            mc.f_91073_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, data.food), dog.m_20185_() + (double)dx1 + d1, dog.m_20186_() + (double)dog.m_20192_() + d3, dog.m_20189_() + (double)dz1 + d5, d6, d7, d8);
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendDogEatingParticlePacketToNearby(AbstractDog dog, ItemStack food) {
            int RADIUS = 64;
            PacketDistributor.TargetPoint tarp = new PacketDistributor.TargetPoint(dog.m_20185_(), dog.m_20186_(), dog.m_20189_(), 64.0, dog.f_19853_.m_46472_());
            PacketHandler.send(PacketDistributor.NEAR.with(() -> tarp), new DogEatingParticleData(dog.m_19879_(), food));
        }
    }

    public static class CritEmitterPacket
    implements IPacket<ParticleData.CritEmitterData> {
        @Override
        public void encode(ParticleData.CritEmitterData data, FriendlyByteBuf buf) {
            buf.writeInt(data.targetId);
        }

        @Override
        public ParticleData.CritEmitterData decode(FriendlyByteBuf buf) {
            return new ParticleData.CritEmitterData(buf.readInt());
        }

        @Override
        public void handle(ParticleData.CritEmitterData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    Minecraft mc = Minecraft.m_91087_();
                    Entity e = mc.f_91073_.m_6815_(data.targetId);
                    if (e != null) {
                        Minecraft.m_91087_().f_91061_.m_107329_(e, (ParticleOptions)ParticleTypes.f_123797_);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendCritEmitterPacketToNearClients(Entity e) {
            int RADIUS = 64;
            PacketDistributor.TargetPoint tarp = new PacketDistributor.TargetPoint(e.m_20185_(), e.m_20186_(), e.m_20189_(), 64.0, e.f_19853_.m_46472_());
            PacketHandler.send(PacketDistributor.NEAR.with(() -> tarp), new ParticleData.CritEmitterData(e.m_19879_()));
        }
    }
}

