/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;

public class CreeperSweeperTalent
extends TalentInstance {
    private int cooldown;

    public CreeperSweeperTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        this.cooldown = dogIn.f_19797_;
    }

    @Override
    public void tick(AbstractDog dog) {
        if (this.level() > 0) {
            List list;
            LivingEntity livingEntity = dog.m_5448_();
            if (livingEntity instanceof Creeper) {
                Creeper creeper = (Creeper)livingEntity;
                creeper.m_32283_(-1);
            }
            if (this.level() >= this.talent.getMaxLevel() && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_CREEPER_SWEEPER_DONT_GROWL)).booleanValue()) {
                return;
            }
            int timeLeft = this.cooldown - dog.f_19797_;
            if (!(timeLeft > 0 || dog.m_21825_() && !dog.m_20159_() || (list = dog.f_19853_.m_45976_(Creeper.class, dog.m_20191_().m_82377_((double)this.getSearchRange(dog), (double)(this.level() * 2), (double)this.getSearchRange(dog)))).isEmpty())) {
                dog.m_5496_(SoundEvents.f_12619_, dog.m_6121_(), (dog.m_217043_().m_188501_() - dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
                this.cooldown = dog.f_19797_ + 60 + dog.m_217043_().m_188503_(40);
            }
        }
    }

    private int getSearchRange(AbstractDog dog) {
        if (dog instanceof Dog) {
            Dog d = (Dog)dog;
            if (d.isMode(EnumMode.GUARD, EnumMode.GUARD_FLAT, EnumMode.GUARD_MINOR)) {
                return Math.min(this.level() * 5, 8);
            }
        }
        return this.level() * 5;
    }

    @Override
    public InteractionResult canAttack(AbstractDog dog, EntityType<?> entityType) {
        return entityType == EntityType.f_20558_ && this.level() >= 5 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public InteractionResult canAttack(AbstractDog dog, LivingEntity entity) {
        return entity instanceof Creeper && this.level() >= 5 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public InteractionResult shouldAttackEntity(AbstractDog dog, LivingEntity target, LivingEntity owner) {
        return target instanceof Creeper && this.level() >= 5 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }
}

