/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.UUID;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class HellHoundTalent
extends TalentInstance {
    private static final UUID FIRE_SWIM_BOOST_ID = UUID.fromString("69192651-74c8-4366-8375-a488628f4556");
    private float oldLavaCost;
    private float oldFireCost;
    private float oldDangerFireCost;
    private Dog dog;
    private final int SEARCH_RANGE = 3;
    private int tickUntilSearch = 0;

    public HellHoundTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
        if (this.level() < 5) {
            return;
        }
        this.oldLavaCost = dog.m_21439_(BlockPathTypes.LAVA);
        this.oldFireCost = dog.m_21439_(BlockPathTypes.DAMAGE_FIRE);
        this.oldDangerFireCost = dog.m_21439_(BlockPathTypes.DANGER_FIRE);
        dog.m_21441_(BlockPathTypes.LAVA, 8.0f);
        dog.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        dog.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        if (dog instanceof Dog) {
            this.dog = (Dog)dog;
        }
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (levelBefore >= 5 && this.level() < 5) {
            dog.m_21441_(BlockPathTypes.LAVA, this.oldLavaCost);
            dog.m_21441_(BlockPathTypes.DAMAGE_FIRE, this.oldFireCost);
            dog.m_21441_(BlockPathTypes.DANGER_FIRE, this.oldDangerFireCost);
        }
    }

    @Override
    public void remove(AbstractDog dog) {
        if (this.level() < 5) {
            return;
        }
        dog.m_21441_(BlockPathTypes.LAVA, this.oldLavaCost);
        dog.m_21441_(BlockPathTypes.DAMAGE_FIRE, this.oldFireCost);
        dog.m_21441_(BlockPathTypes.DANGER_FIRE, this.oldDangerFireCost);
    }

    @Override
    public InteractionResultHolder<Integer> setFire(AbstractDog dogIn, int second) {
        return InteractionResultHolder.m_19090_((Object)(this.level() > 0 ? second / this.level() : second));
    }

    @Override
    public InteractionResult isImmuneToFire(AbstractDog dogIn) {
        return this.level() >= 5 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public InteractionResult isInvulnerableTo(AbstractDog dogIn, DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return this.level() >= 5 ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, Entity entity) {
        if (this.level() > 0) {
            entity.m_20254_(this.level());
        }
    }

    @Override
    public InteractionResult canResistPushFromFluidType(FluidType type) {
        if (type != ForgeMod.LAVA_TYPE.get()) {
            return InteractionResult.PASS;
        }
        if (this.level() >= 5) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void tick(AbstractDog dog) {
        if (this.level() < 5) {
            return;
        }
        if (dog.m_20077_()) {
            this.applySwimAttributes(dog);
        } else {
            this.removeSwimAttributes(dog);
        }
        if (this.dog != null && this.dog.isShakingLava() && (double)this.dog.getTimeDogIsShaking() > 0.8 && --this.tickUntilSearch <= 0) {
            this.tickUntilSearch = 10;
            this.fireSpreadToEnermies();
        }
    }

    private void fireSpreadToEnermies() {
        List targets = this.dog.f_19853_.m_45976_(LivingEntity.class, this.dog.m_20191_().m_82377_(3.0, 2.0, 3.0));
        for (LivingEntity x : targets) {
            if (!(x instanceof Enemy)) continue;
            x.m_20254_(5);
        }
    }

    private void applySwimAttributes(AbstractDog dog) {
        dog.setAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), FIRE_SWIM_BOOST_ID, (dd, u) -> new AttributeModifier(u, "Lava Swim Boost", 4.0, AttributeModifier.Operation.ADDITION));
    }

    private void removeSwimAttributes(AbstractDog dog) {
        dog.removeAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), FIRE_SWIM_BOOST_ID);
    }

    @Override
    public InteractionResult isBlockTypeWalkable(AbstractDog dog, BlockPathTypes type) {
        if (this.level < 5) {
            return InteractionResult.PASS;
        }
        if (type == BlockPathTypes.DANGER_FIRE) {
            return InteractionResult.SUCCESS;
        }
        if (type == BlockPathTypes.LAVA) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

