/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.util.EntityUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;

public class PuppyEyesTalent
extends TalentInstance {
    private int cooldown;

    public PuppyEyesTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public TalentInstance copy() {
        PuppyEyesTalent inst = new PuppyEyesTalent(this.getTalent(), this.level);
        inst.cooldown = this.cooldown;
        return inst;
    }

    @Override
    public void init(AbstractDog dogIn) {
        this.cooldown = dogIn.f_19797_;
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        int timeLeft = this.cooldown - dogIn.f_19797_;
        compound.m_128405_("cooldown", timeLeft);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.cooldown = dogIn.f_19797_ + compound.m_128451_("cooldown");
    }

    @Override
    public void onRead(AbstractDog dogIn, CompoundTag compound) {
        if (compound.m_128441_("charmercharge")) {
            this.cooldown = dogIn.f_19797_ + compound.m_128451_("charmercharge");
        }
    }

    @Override
    public void livingTick(AbstractDog dogIn) {
        if (dogIn.f_19797_ % 40 != 0) {
            return;
        }
        if (dogIn.f_19853_.f_46443_ || !dogIn.m_21824_()) {
            return;
        }
        if (this.level() <= 0) {
            return;
        }
        int timeLeft = this.cooldown - dogIn.f_19797_;
        if (timeLeft <= 0) {
            LivingEntity owner = dogIn.m_269323_();
            if (owner == null) {
                return;
            }
            Villager villager = this.getClosestVisibleVillager(dogIn, 5.0);
            if (villager != null) {
                int add_val = this.level() * 20;
                villager.m_35517_().m_26191_(owner.m_20148_(), GossipType.MINOR_POSITIVE, add_val);
                this.cooldown = dogIn.f_19797_ + (this.level() >= 5 ? 24000 : 48000);
            }
        }
    }

    public Villager getClosestVisibleVillager(AbstractDog dogIn, double radiusIn) {
        List list = dogIn.f_19853_.m_6443_(Villager.class, dogIn.m_20191_().m_82377_(radiusIn, radiusIn, radiusIn), village -> village.m_142582_((Entity)dogIn));
        return (Villager)EntityUtil.getClosestTo((Entity)dogIn, list);
    }
}

