/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogWaterBoundNavigation;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class SwimmerDogTalent
extends TalentInstance {
    private SmoothSwimmingMoveControl moveControl;
    private WaterBoundPathNavigation navigator;
    private static final UUID SWIM_BOOST_ID = UUID.fromString("50671e42-1ded-4f97-9e2b-78bbeb1e8772");
    private boolean swimming;
    private float oldWaterCost;
    private float oldWaterBorderCost;

    public SwimmerDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
        this.moveControl = new SmoothSwimmingMoveControl((Mob)dog, dog.m_8132_(), dog.m_8085_(), 1.0f, 1.0f, false);
        this.navigator = new DogWaterBoundNavigation((Mob)dog, dog.f_19853_);
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        LivingEntity rider;
        if (abstractDog.f_19853_.f_46443_) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (this.level() >= 5 && dog.m_20160_() && (rider = dog.m_6688_()).m_20069_()) {
            rider.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 80, 1, true, false));
        }
        if (this.swimming) {
            this.updateSwimming(dog);
        } else {
            this.updateNotSwimming(dog);
        }
    }

    @Override
    public void remove(AbstractDog abstractDog) {
        if (this.swimming && abstractDog instanceof Dog) {
            Dog dog = (Dog)abstractDog;
            this.stopSwimming(dog);
        }
    }

    private void updateSwimming(Dog dog) {
        if (!dog.m_20069_() && dog.m_20096_() || dog.isLowAirSupply() || this.isNearLand(dog)) {
            this.swimming = false;
            this.stopSwimming(dog);
        }
    }

    private void updateNotSwimming(Dog dog) {
        if (dog.m_20069_() && this.readyToBeginSwimming(dog) && !this.isNearLand(dog)) {
            this.swimming = true;
            this.startSwimming(dog);
        }
    }

    private boolean isNearLand(Dog dog) {
        BlockPos dog_b0 = dog.m_20183_();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)dog_b0.m_7918_(-1, -1, -1), (BlockPos)dog_b0.m_7918_(1, 1, 1))) {
            BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)dog.f_19853_, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (type != BlockPathTypes.WALKABLE && type != BlockPathTypes.WATER_BORDER) continue;
            return true;
        }
        return false;
    }

    private boolean readyToBeginSwimming(Dog dog) {
        return dog.m_20146_() == dog.m_6062_();
    }

    private void applySwimAttributes(Dog dog) {
        dog.setAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_BOOST_ID, (dd, u) -> new AttributeModifier(u, "Swim Boost", (double)(2 * dog.getDogLevel((Supplier)DoggyTalents.SWIMMER_DOG)), AttributeModifier.Operation.ADDITION));
    }

    private void removeSwimAttributes(Dog dog) {
        dog.removeAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_BOOST_ID);
    }

    private void startSwimming(Dog dog) {
        dog.m_6862_(false);
        dog.setNavigation((PathNavigation)this.navigator);
        dog.setMoveControl((MoveControl)this.moveControl);
        if (dog.m_21825_()) {
            dog.m_21837_(false);
        }
        this.applySwimAttributes(dog);
        this.oldWaterCost = dog.m_21439_(BlockPathTypes.WATER);
        this.oldWaterBorderCost = dog.m_21439_(BlockPathTypes.WATER_BORDER);
        dog.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        dog.m_21441_(BlockPathTypes.WATER, 0.0f);
        dog.setDogSwimming(true);
    }

    private void stopSwimming(Dog dog) {
        dog.resetMoveControl();
        dog.resetNavigation();
        this.removeSwimAttributes(dog);
        dog.m_21441_(BlockPathTypes.WATER_BORDER, this.oldWaterBorderCost);
        dog.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        dog.setDogSwimming(false);
    }

    @Override
    public InteractionResult canBeRiddenInWater(AbstractDog dogIn) {
        return this.level() >= 2 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public InteractionResult canBreatheUnderwater(AbstractDog dogIn) {
        return this.level() >= 5 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<Integer> decreaseAirSupply(AbstractDog dogIn, int air) {
        if (this.level() > 0 && dogIn.m_217043_().m_188503_(this.level() + 1) > 0) {
            return InteractionResultHolder.m_19090_((Object)air);
        }
        return InteractionResultHolder.m_19098_((Object)air);
    }

    @Override
    public InteractionResultHolder<Integer> determineNextAir(AbstractDog dogIn, int currentAir) {
        if (this.level() > 0) {
            return InteractionResultHolder.m_19098_((Object)(currentAir + this.level()));
        }
        return InteractionResultHolder.m_19098_((Object)currentAir);
    }

    @Override
    public InteractionResult canSwimUnderwater(AbstractDog dogIn) {
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult canResistPushFromFluidType(FluidType type) {
        if (type != ForgeMod.WATER_TYPE.get()) {
            return InteractionResult.PASS;
        }
        if (this.level() >= 2) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult isBlockTypeWalkable(AbstractDog dog, BlockPathTypes type) {
        if (type == BlockPathTypes.WATER) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

