/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.Screens;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.DoggyToolsItemHandler;
import doggytalents.common.talent.doggy_tools.ToolActionEntries;
import doggytalents.common.talent.doggy_tools.tool_actions.ToolAction;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;

public class DoggyToolsTalent
extends TalentInstance {
    private DoggyToolsItemHandler tools = new DoggyToolsItemHandler();
    private Map<Item, ToolAction> TOOL_ACTION_MAP;

    public DoggyToolsTalent(Talent talentIn, int level) {
        super(talentIn, level);
    }

    public static int getSize(int level) {
        return Mth.m_14045_((int)level, (int)0, (int)5);
    }

    @Override
    public void init(AbstractDog dog) {
        this.TOOL_ACTION_MAP = ToolActionEntries.getToolActionMapFor((Dog)dog, this);
    }

    @Override
    public boolean hasRenderer() {
        return true;
    }

    @Override
    public void remove(AbstractDog dog) {
        dog.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (dog.f_19853_.f_46443_) {
            return;
        }
        if (levelBefore > 0 && this.level() <= 0) {
            this.dropAllToolbar(dog);
        }
    }

    private void dropAllToolbar(AbstractDog dog) {
        for (int i = 0; i < this.tools.getSlots(); ++i) {
            Containers.m_18992_((Level)dog.f_19853_, (double)dog.m_20185_(), (double)dog.m_20186_(), (double)dog.m_20189_(), (ItemStack)this.tools.getStackInSlot(i));
            this.tools.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Override
    public void tick(AbstractDog d) {
        if (d.f_19853_.f_46443_) {
            return;
        }
        this.validateAndSync(d);
        if (!(d instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)d;
        if (dog.isBusy() || dog.m_21827_()) {
            return;
        }
        if (dog.m_5448_() != null) {
            this.pickTargetTool(dog);
            return;
        }
        dog.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        LivingEntity owner = dog.m_269323_();
        if (owner == null || dog.m_20280_((Entity)owner) > (double)this.getMaxOwnerDistSqr()) {
            return;
        }
        this.pickActionTool(dog);
    }

    private void validateAndSync(AbstractDog d) {
        ItemStack stack = d.m_21205_();
        if (!this.tools.hasStackRef(stack)) {
            d.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    private void pickTargetTool(Dog dog) {
        for (int i = 0; i < DoggyToolsTalent.getSize(this.level()); ++i) {
            Item item;
            ItemStack stack = this.tools.getStackInSlot(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof SwordItem)) continue;
            dog.m_8061_(EquipmentSlot.MAINHAND, stack);
            break;
        }
    }

    private void pickActionTool(Dog dog) {
        for (int i = 0; i < DoggyToolsTalent.getSize(this.level()); ++i) {
            Item item;
            ToolAction action;
            ItemStack stack = this.tools.getStackInSlot(i);
            if (stack.m_41619_() || (action = this.TOOL_ACTION_MAP.get(item = stack.m_41720_())) == null || !action.shouldUse()) continue;
            dog.m_8061_(EquipmentSlot.MAINHAND, stack);
            dog.triggerAction(action);
            break;
        }
    }

    public DoggyToolsItemHandler getTools() {
        return this.tools;
    }

    @Override
    public InteractionResult processInteract(AbstractDog d, Level levek, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!(stack.m_41720_() instanceof PickaxeItem)) {
            return InteractionResult.PASS;
        }
        if (!(d instanceof Dog)) {
            return InteractionResult.PASS;
        }
        Dog dog = (Dog)d;
        if (!dog.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)player;
            Screens.openDoggyToolsScreen(sP, dog);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("tool_inv", (Tag)this.tools.serializeNBT());
        compound.m_128365_("doggy_tools", (Tag)tag);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        CompoundTag tag = compound.m_128469_("doggy_tools");
        if (tag == null) {
            return;
        }
        CompoundTag inv_tag = tag.m_128469_("tool_inv");
        if (inv_tag != null) {
            this.tools.deserializeNBT(inv_tag);
        }
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, Entity target) {
        ItemStack stack = dogIn.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof SwordItem)) {
            return;
        }
        SwordItem sword = (SwordItem)item;
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)target;
        sword.m_7579_(stack, living, (LivingEntity)dogIn);
    }

    public int getMaxOwnerDistSqr() {
        return 64;
    }
}

