/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.CachedSearchUtil;

import doggytalents.api.inferface.IDogAlteration;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.CachedSearchPool;
import doggytalents.common.util.DogUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class CachedSearchUtil {
    public static void resetPool(Level level, int radiusXZ, int radiusY) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    CachedSearchPool.setPoolValue(level, i, j, k, (byte)0);
                }
            }
        }
    }

    public static void populatePoolRaw(Dog dog, BlockPos targetPos, int radiusXZ, int radiusY) {
        BlockPos b0 = targetPos;
        BlockPos bMin = b0.m_7918_(-radiusXZ, -radiusY, -radiusXZ);
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    BlockPathTypes type = WalkNodeEvaluatorDelegate.getTypeDelegate((BlockGetter)dog.f_19853_, bMin.m_7918_(i, j, k));
                    byte val = CachedSearchUtil.inferType(dog, type);
                    CachedSearchPool.setPoolValue(dog.f_19853_, i, j, k, val);
                }
            }
        }
    }

    public static void populatePoolRaw(Level level, List<Dog> dogs, BlockPos targetPos, int radiusXZ, int radiusY) {
        BlockPos b0 = targetPos;
        BlockPos bMin = b0.m_7918_(-radiusXZ, -radiusY, -radiusXZ);
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    BlockPathTypes type = WalkNodeEvaluatorDelegate.getTypeDelegate((BlockGetter)level, bMin.m_7918_(i, j, k));
                    byte val = CachedSearchUtil.inferType(dogs, type);
                    CachedSearchPool.setPoolValue(level, i, j, k, val);
                }
            }
        }
    }

    public static void populateCollideOwner(LivingEntity owner, int radiusXZ, int radiusY) {
        double DISTANCE_AWAY = 1.5;
        float a1 = owner.m_6080_();
        float dx1 = -Mth.m_14031_((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = Mth.m_14089_((float)(a1 * ((float)Math.PI / 180)));
        Vec3 ownerLookUnitVector = new Vec3((double)dx1, 0.0, (double)dz1);
        Vec3 ownerPosRelative2d = new Vec3((double)radiusXZ, 0.0, (double)radiusXZ);
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int k = 0; k <= maxXZ; ++k) {
                double x = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(new Vec3((double)i, 0.0, (double)k), ownerPosRelative2d, ownerLookUnitVector);
                if (x < 0.0 || x > 1.5) continue;
                for (int j = 0; j <= maxY; ++j) {
                    CachedSearchPool.setPoolValue(owner.f_19853_, i, j, k, (byte)5);
                }
            }
        }
        int cXZ = radiusXZ;
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                for (int j = 0; j <= maxY; ++j) {
                    CachedSearchPool.setPoolValue(owner.f_19853_, cXZ + i, j, cXZ + k, (byte)5);
                }
            }
        }
    }

    public static void populateBlockCollision(Dog dog, int radiusXZ, int radiusY) {
        int bbWExt = Mth.m_14165_((double)((double)(dog.m_20205_() - 1.0f) * 0.5));
        int bbHExt = Mth.m_14165_((double)((double)(dog.m_20206_() - 1.0f) * 0.5));
        if (bbWExt <= 0 && bbHExt <= 0) {
            return;
        }
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    if (CachedSearchPool.getPoolValue(dog.f_19853_, i, j, k) != 2) continue;
                    for (int i1 = i - bbWExt; i1 <= i + bbWExt; ++i1) {
                        for (int j1 = j - bbHExt; j1 <= j; ++j1) {
                            for (int k1 = k - bbWExt; k1 <= k + bbWExt; ++k1) {
                                if (CachedSearchPool.getPoolValue(dog.f_19853_, i1, j1, k1) == 2 || CachedSearchPool.getPoolValue(dog.f_19853_, i1, j1, k1) == 6) continue;
                                CachedSearchPool.setPoolValue(dog.f_19853_, i1, j1, k1, (byte)5);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void populateBlockCollision(Level level, List<Dog> dogs, int radiusXZ, int radiusY) {
        Dog dog = DogUtil.findBiggestDog(dogs);
        int bbWExt = Mth.m_14165_((double)((double)(dog.m_20205_() - 1.0f) * 0.5));
        int bbHExt = Mth.m_14165_((double)((double)(dog.m_20206_() - 1.0f) * 0.5));
        if (bbWExt <= 0 && bbHExt <= 0) {
            return;
        }
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    if (CachedSearchPool.getPoolValue(level, i, j, k) != 2) continue;
                    for (int i1 = i - bbWExt; i1 <= i + bbWExt; ++i1) {
                        for (int j1 = j - bbHExt; j1 <= j; ++j1) {
                            for (int k1 = k - bbWExt; k1 <= k + bbWExt; ++k1) {
                                if (CachedSearchPool.getPoolValue(level, i1, j1, k1) == 2 || CachedSearchPool.getPoolValue(level, i1, j1, k1) == 6) continue;
                                CachedSearchPool.setPoolValue(level, i1, j1, k1, (byte)5);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void populateDangerPos(Level level, int radiusXZ, int radiusY) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    if (CachedSearchPool.getPoolValue(level, i, j, k) != -1) continue;
                    for (int i1 = i - 1; i1 <= i + 1; ++i1) {
                        for (int j1 = j - 1; j1 <= j + 1; ++j1) {
                            for (int k1 = k - 1; k1 <= k + 1; ++k1) {
                                if (CachedSearchPool.getPoolValue(level, i1, j1, k1) != 1) continue;
                                CachedSearchPool.setPoolValue(level, i1, j1, k1, (byte)3);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void populateWalkablePos(Level level, int radiusXZ, int radiusY) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    byte val = CachedSearchPool.getPoolValue(level, i, j, k);
                    byte val_below = CachedSearchPool.getPoolValue(level, i, j - 1, k);
                    if (val != 1 || val_below != 2) continue;
                    CachedSearchPool.setPoolValue(level, i, j, k, (byte)4);
                }
            }
        }
    }

    public static int countWalkablePos(Level level, int radiusXZ, int radiusY) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        int count = 0;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    byte val = CachedSearchPool.getPoolValue(level, i, j, k);
                    if (val != 4) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static void populatePool(Dog dog, BlockPos targetPos, int radiusXZ, int radiusY) {
        CachedSearchUtil.resetPool(dog.f_19853_, radiusXZ, radiusY);
        CachedSearchUtil.populatePoolRaw(dog, targetPos, radiusXZ, radiusY);
        CachedSearchUtil.populateBlockCollision(dog, radiusXZ, radiusY);
        CachedSearchUtil.populateDangerPos(dog.f_19853_, radiusXZ, radiusY);
        CachedSearchUtil.populateWalkablePos(dog.f_19853_, radiusXZ, radiusY);
    }

    public static void populatePool(Level level, List<Dog> dogs, BlockPos targetPos, int radiusXZ, int radiusY) {
        CachedSearchUtil.resetPool(level, radiusXZ, radiusY);
        CachedSearchUtil.populatePoolRaw(level, dogs, targetPos, radiusXZ, radiusY);
        CachedSearchUtil.populateBlockCollision(level, dogs, radiusXZ, radiusY);
        CachedSearchUtil.populateDangerPos(level, radiusXZ, radiusY);
        CachedSearchUtil.populateWalkablePos(level, radiusXZ, radiusY);
    }

    public static List<BlockPos> collectSafePos(Level level, BlockPos targetPos, int radiusXZ, int radiusY) {
        ArrayList<BlockPos> safePosList = new ArrayList<BlockPos>();
        BlockPos b0 = targetPos;
        BlockPos bMin = b0.m_7918_(-radiusXZ, -radiusY, -radiusXZ);
        int maxXZ = radiusXZ * 2 - 1;
        int maxY = radiusY * 2 - 1;
        for (int i = 1; i <= maxXZ; ++i) {
            for (int j = 1; j <= maxY; ++j) {
                for (int k = 1; k <= maxXZ; ++k) {
                    if (CachedSearchPool.getPoolValue(level, i, j, k) != 4) continue;
                    BlockPos pos = bMin.m_7918_(i, j, k);
                    safePosList.add(pos);
                }
            }
        }
        return safePosList;
    }

    public static BlockPos getRandomSafePosUsingPool(Dog dog, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        List<BlockPos> safePosList = CachedSearchUtil.getAllSafePosUsingPool(dog, targetPos, realRadiusXZ, realRadiusY);
        if (safePosList.isEmpty()) {
            return null;
        }
        int index = dog.m_217043_().m_188503_(safePosList.size());
        return safePosList.get(index);
    }

    public static BlockPos getRandomSafePosUsingPoolExcludeInfrontOfOwner(Dog dog, LivingEntity owner, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        List<BlockPos> safePosList = CachedSearchUtil.getAllSafePosUsingPoolExcludeInfrontOfOwner(dog, owner, targetPos, realRadiusXZ, realRadiusY);
        if (safePosList.isEmpty()) {
            return null;
        }
        int index = dog.m_217043_().m_188503_(safePosList.size());
        return safePosList.get(index);
    }

    public static List<BlockPos> getAllSafePosUsingPool(Dog dog, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchUtil.populatePool(dog, targetPos, poolXZ, poolY);
        List<BlockPos> safePosList = CachedSearchUtil.collectSafePos(dog.f_19853_, targetPos, poolXZ, poolY);
        return safePosList;
    }

    public static List<BlockPos> getAllSafePosUsingPoolExcludeInfrontOfOwner(Dog dog, LivingEntity owner, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchUtil.populatePool(dog, targetPos, poolXZ, poolY);
        CachedSearchUtil.populateCollideOwner(owner, poolXZ, poolY);
        List<BlockPos> safePosList = CachedSearchUtil.collectSafePos(dog.f_19853_, targetPos, poolXZ, poolY);
        return safePosList;
    }

    public static List<BlockPos> getAllSafePosUsingPool(Level level, List<Dog> dogs, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchUtil.populatePool(level, dogs, targetPos, poolXZ, poolY);
        List<BlockPos> safePosList = CachedSearchUtil.collectSafePos(level, targetPos, poolXZ, poolY);
        return safePosList;
    }

    public static List<BlockPos> getAllSafePosUsingPoolExcludeInfrontOfOwner(Level level, List<Dog> dogs, LivingEntity owner, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchUtil.populatePool(level, dogs, targetPos, poolXZ, poolY);
        CachedSearchUtil.populateCollideOwner(owner, poolXZ, poolY);
        List<BlockPos> safePosList = CachedSearchUtil.collectSafePos(level, targetPos, poolXZ, poolY);
        return safePosList;
    }

    public static String dumpPool(Level level, int radiusXZ, int radiusY) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        StringBuilder builder = new StringBuilder();
        for (int i = maxY; i >= 0; --i) {
            builder.append("Layer " + i + ": X -> \n");
            for (int j = 0; j <= maxXZ; ++j) {
                builder.append("-" + j + "-  ");
                for (int k = 0; k <= maxXZ; ++k) {
                    builder.append(CachedSearchPool.getPoolValue(level, k, i, j) + ", ");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public static byte inferType(Dog dog, BlockPathTypes type) {
        for (IDogAlteration x : dog.getAlterations()) {
            if (!x.isBlockTypeWalkable(dog, type).m_19080_()) continue;
            return 4;
        }
        if (type == BlockPathTypes.OPEN) {
            return 1;
        }
        if (type.getDanger() != null) {
            return -1;
        }
        if (dog.m_21439_(type) < 0.0f) {
            return 2;
        }
        return 1;
    }

    public static byte inferType(List<Dog> dogs, BlockPathTypes type) {
        boolean all_dog_OK = true;
        for (Dog dog : dogs) {
            boolean is_ok = false;
            for (IDogAlteration x : dog.getAlterations()) {
                if (!x.isBlockTypeWalkable(dog, type).m_19080_()) continue;
                is_ok = true;
                break;
            }
            if (is_ok) continue;
            all_dog_OK = false;
            break;
        }
        if (all_dog_OK) {
            return 4;
        }
        if (type == BlockPathTypes.OPEN) {
            return 1;
        }
        if (type.getDanger() != null) {
            return -1;
        }
        for (Dog dog : dogs) {
            if (!(dog.m_21439_(type) < 0.0f)) continue;
            return 2;
        }
        return 1;
    }

    private static class WalkNodeEvaluatorDelegate
    extends WalkNodeEvaluator {
        private WalkNodeEvaluatorDelegate() {
        }

        public static BlockPathTypes getTypeDelegate(BlockGetter getter, BlockPos pos) {
            return WalkNodeEvaluator.m_77643_((BlockGetter)getter, (BlockPos)pos);
        }
    }
}

