/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.CachedSearchUtil;

import doggytalents.common.entity.Dog;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class DogGreedyFireSafeSearchPath
extends Path {
    private ArrayList<Node> nodes;
    private Dog dog;
    public boolean finished;
    private int maxLength;

    private DogGreedyFireSafeSearchPath(Dog dog, ArrayList<Node> nodes, int maxLength) {
        super(nodes, dog.m_20183_(), false);
        this.nodes = nodes;
        this.dog = dog;
        this.maxLength = maxLength;
    }

    public static DogGreedyFireSafeSearchPath create(Dog dog, int maxLength) {
        ArrayList<Node> initNodes = new ArrayList<Node>(maxLength);
        BlockPos dog_b0 = dog.m_20183_();
        initNodes.add(new Node(dog_b0.m_123341_(), dog_b0.m_123342_(), dog_b0.m_123343_()));
        DogGreedyFireSafeSearchPath ret = new DogGreedyFireSafeSearchPath(dog, initNodes, maxLength);
        Node pos = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(ret);
        if (pos == null) {
            return null;
        }
        initNodes.clear();
        initNodes.add(pos);
        return ret;
    }

    public void m_77374_() {
        super.m_77374_();
        if (this.finished) {
            return;
        }
        if (this.m_77399_() >= this.maxLength) {
            return;
        }
        this.tryAppendPath();
    }

    public boolean m_77392_() {
        return super.m_77392_();
    }

    public void tryAppendPath() {
        Node node = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(this);
        if (node != null) {
            this.nodes.add(node);
        }
    }

    private boolean containNode(BlockPos node0) {
        for (Node node : this.nodes) {
            if (!node.equals((Object)new Node(node0.m_123341_(), node0.m_123342_(), node0.m_123343_()))) continue;
            return true;
        }
        return false;
    }

    private static Node scanSurroundingForNextPos(DogGreedyFireSafeSearchPath path) {
        int j;
        int i;
        if (path.nodes.isEmpty()) {
            return null;
        }
        BlockPos b0 = path.nodes.get(path.nodes.size() - 1).m_77288_();
        float malus_min = Float.MAX_VALUE;
        Node node_chosen = null;
        boolean[] X0_BLOCKED = new boolean[2];
        boolean[] Y0_BLOCKED = new boolean[2];
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                Node node;
                if (i == 0 && j == 0 || i * j != 0 || (node = DogGreedyFireSafeSearchPath.checkPos(path, b0.m_7918_(i, 0, j))) == null) continue;
                if (node.f_77282_ == BlockPathTypes.WALKABLE) {
                    return node;
                }
                if (node.f_77282_ == BlockPathTypes.BLOCKED) {
                    if (i != 0) {
                        Y0_BLOCKED[i > 0 ? 1 : 0] = true;
                        continue;
                    }
                    X0_BLOCKED[j > 0 ? 1 : 0] = true;
                    continue;
                }
                float malus = path.dog.m_21439_(node.f_77282_);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                Node node;
                boolean diagonal_blocked;
                if (i == 0 && j == 0 || i * j == 0) continue;
                boolean bl = X0_BLOCKED[j > 0 ? 1 : 0] && Y0_BLOCKED[i > 0 ? 1 : 0] ? true : (diagonal_blocked = false);
                if (diagonal_blocked || (node = DogGreedyFireSafeSearchPath.checkPos(path, b0.m_7918_(i, 0, j))) == null) continue;
                if (node.f_77282_ == BlockPathTypes.WALKABLE) {
                    return node;
                }
                if (node.f_77282_ == BlockPathTypes.BLOCKED) {
                    if (i != 0) {
                        Y0_BLOCKED[i > 0 ? 1 : 0] = true;
                        continue;
                    }
                    X0_BLOCKED[j > 0 ? 1 : 0] = true;
                    continue;
                }
                float malus = path.dog.m_21439_(node.f_77282_);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        if (node_chosen != null) {
            return node_chosen;
        }
        path.finished = true;
        return null;
    }

    private static Node checkPos(DogGreedyFireSafeSearchPath path, BlockPos pos) {
        BlockPos.MutableBlockPos b1 = pos.m_122032_();
        BlockPathTypes b1_type = WalkNodeEvaluator.m_77604_((BlockGetter)path.dog.f_19853_, (BlockPos.MutableBlockPos)b1.m_122032_());
        int offsetY = 0;
        if (b1_type == BlockPathTypes.BLOCKED) {
            offsetY = 1;
        } else if (b1_type == BlockPathTypes.OPEN) {
            offsetY = -1;
        }
        if (offsetY != 0) {
            b1.m_122184_(0, offsetY, 0);
            b1_type = WalkNodeEvaluator.m_77604_((BlockGetter)path.dog.f_19853_, (BlockPos.MutableBlockPos)b1.m_122032_());
        }
        if (b1_type == BlockPathTypes.WALKABLE || b1_type == BlockPathTypes.BLOCKED) {
            Node ret_node = new Node(b1.m_123341_(), b1.m_123342_(), b1.m_123343_());
            ret_node.f_77282_ = b1_type;
            return ret_node;
        }
        if (b1_type == BlockPathTypes.OPEN) {
            return null;
        }
        if (path.containNode((BlockPos)b1)) {
            return null;
        }
        float malus = path.dog.m_21439_(b1_type);
        if (malus < 0.0f) {
            return null;
        }
        Node ret_node = new Node(b1.m_123341_(), b1.m_123342_(), b1.m_123343_());
        ret_node.f_77282_ = b1_type;
        return ret_node;
    }
}

