/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.inferface.IDogAlteration;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.CachedSearchUtil.CachedSearchUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.doggyasynctask.DogAsyncTaskManager;
import doggytalents.common.util.doggyasynctask.promise.DogDistantTeleportToBedPromise;
import doggytalents.common.util.doggyasynctask.promise.DogDistantTeleportToOwnerPromise;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DogUtil {
    public static boolean dynamicSearchAndTeleportToOwnwer(Dog dog, LivingEntity owner, int radius) {
        BlockPos target = owner.m_20142_() || dog.isMiningCautious() ? CachedSearchUtil.getRandomSafePosUsingPoolExcludeInfrontOfOwner(dog, owner, owner.m_20183_(), radius, 1) : CachedSearchUtil.getRandomSafePosUsingPool(dog, owner.m_20183_(), radius, 1);
        if (target == null) {
            return false;
        }
        DogUtil.teleportInternal(dog, target);
        return true;
    }

    public static boolean dynamicSearchAndTeleportToOwnwerInBatch(Level level, List<Dog> dogs, LivingEntity owner, int radius) {
        if (dogs.isEmpty()) {
            return false;
        }
        long startTime = System.nanoTime();
        List<BlockPos> safePosList = owner.m_20142_() ? CachedSearchUtil.getAllSafePosUsingPoolExcludeInfrontOfOwner(level, dogs, owner, owner.m_20183_(), radius, 1) : CachedSearchUtil.getAllSafePosUsingPool(level, dogs, owner.m_20183_(), radius, 1);
        if (safePosList.isEmpty()) {
            return false;
        }
        for (Dog dog : dogs) {
            int r_indx = dog.m_217043_().m_188503_(safePosList.size());
            DogUtil.teleportInternal(dog, safePosList.get(r_indx));
        }
        long stopTime = System.nanoTime();
        return true;
    }

    public static boolean dynamicSearchAndTeleportToOwnwerInBatchMaxDensity(Level level, List<Dog> dogs, LivingEntity owner, int radius, int max_density) {
        if (dogs.isEmpty()) {
            return false;
        }
        long startTime = System.nanoTime();
        List<BlockPos> safePosList = owner.m_20142_() ? CachedSearchUtil.getAllSafePosUsingPoolExcludeInfrontOfOwner(level, dogs, owner, owner.m_20183_(), radius, 1) : CachedSearchUtil.getAllSafePosUsingPool(level, dogs, owner.m_20183_(), radius, 1);
        if (safePosList.isEmpty()) {
            return false;
        }
        ArrayList<Integer> densityMap = new ArrayList<Integer>(safePosList.size());
        for (int i = 0; i < safePosList.size(); ++i) {
            densityMap.add(0);
        }
        ArrayList<Dog> sorted_dogs = new ArrayList<Dog>(dogs);
        Collections.sort(sorted_dogs, new EntityUtil.Sorter((Entity)owner));
        for (Dog dog : sorted_dogs) {
            if (safePosList.isEmpty()) break;
            int r_indx = dog.m_217043_().m_188503_(safePosList.size());
            DogUtil.teleportInternal(dog, safePosList.get(r_indx));
            int density_count = (Integer)densityMap.get(r_indx) + 1;
            if (density_count >= max_density) {
                densityMap.remove(r_indx);
                safePosList.remove(r_indx);
                continue;
            }
            densityMap.set(r_indx, density_count);
        }
        long stopTime = System.nanoTime();
        return true;
    }

    public static boolean dynamicSearchAndTeleportToBlockPos(Dog dog, BlockPos pos, int radius) {
        BlockPos target = CachedSearchUtil.getRandomSafePosUsingPool(dog, pos, radius, 1);
        if (target == null) {
            return false;
        }
        DogUtil.teleportInternal(dog, target);
        return true;
    }

    public static boolean guessAndTryToTeleportToOwner(Dog dog, LivingEntity owner, int radius) {
        BlockPos owner_b0 = owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int randZ;
            int randY;
            int randX = owner_b0.m_123341_() + EntityUtil.getRandomNumber((LivingEntity)dog, -radius, radius);
            BlockPos b0 = new BlockPos(randX, randY = owner_b0.m_123342_() + EntityUtil.getRandomNumber((LivingEntity)dog, -1, 1), randZ = owner_b0.m_123343_() + EntityUtil.getRandomNumber((LivingEntity)dog, -radius, radius));
            if (!DogUtil.wantToTeleportToThePosition(dog, owner, b0)) continue;
            DogUtil.teleportInternal(dog, b0);
            return true;
        }
        return false;
    }

    public static boolean wantToTeleportToThePosition(Dog dog, LivingEntity owner, BlockPos pos) {
        BlockPos owner_b0 = owner.m_20183_();
        boolean flag = (Mth.m_14040_((int)(owner_b0.m_123341_() - pos.m_123341_())) >= 2 || Mth.m_14040_((int)(owner_b0.m_123343_() - pos.m_123343_())) >= 2) && DogUtil.isTeleportSafeBlock(dog, pos) && (!owner.m_20142_() && !dog.isMiningCautious() || !DogUtil.posWillCollideWithOwnerMovingForward(dog, owner, pos));
        return flag;
    }

    public static boolean posWillCollideWithOwnerMovingForward(Dog dog, LivingEntity owner, BlockPos pos) {
        float dz1;
        float a1;
        float dx1;
        Vec3 ownerLookUnitVector;
        double DISTANCE_AWAY = 1.5;
        Vec3 ownerPos = owner.m_20182_();
        Vec3 ownerPos2d = new Vec3(ownerPos.m_7096_(), 0.0, ownerPos.m_7094_());
        Vec3 targetPos2d = new Vec3((double)pos.m_123341_() + 0.5, 0.0, (double)pos.m_123343_() + 0.5);
        double x = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(targetPos2d, ownerPos2d, ownerLookUnitVector = new Vec3((double)(dx1 = -Mth.m_14031_((float)((a1 = owner.m_6080_()) * ((float)Math.PI / 180)))), 0.0, (double)(dz1 = Mth.m_14089_((float)(a1 * ((float)Math.PI / 180))))));
        return !(x < 0.0) && !(x > 1.5);
    }

    public static boolean hasLineOfSightToOwnerAtPos(Dog dog, LivingEntity owner, BlockPos pos) {
        Vec3 pos2;
        Vec3 pos1 = new Vec3((double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + owner.m_20192_()), (double)pos.m_123343_() + 0.5);
        if (pos1.m_82554_(pos2 = new Vec3(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20192_(), owner.m_20189_())) > 128.0) {
            return false;
        }
        return dog.f_19853_.m_45547_(new ClipContext(pos1, pos2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dog)).m_6662_() == HitResult.Type.MISS;
    }

    public static boolean isTeleportSafeBlock(Dog dog, BlockPos pos) {
        BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)dog.f_19853_, (BlockPos.MutableBlockPos)pos.m_122032_());
        boolean alterationWalkable = false;
        for (IDogAlteration x : dog.getAlterations()) {
            if (!x.isBlockTypeWalkable(dog, pathnodetype).m_19080_()) continue;
            alterationWalkable = true;
            break;
        }
        if (pathnodetype != BlockPathTypes.WALKABLE && !alterationWalkable) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)dog.m_20183_());
        return dog.f_19853_.m_45756_((Entity)dog, dog.m_20191_().m_82338_(blockpos));
    }

    public static boolean isTeleportSafeBlockMidAir(Dog dog, BlockPos pos) {
        BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)dog.f_19853_, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathnodetype != BlockPathTypes.OPEN) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)dog.m_20183_());
        return dog.f_19853_.m_45756_((Entity)dog, dog.m_20191_().m_82338_(blockpos));
    }

    public static double distanceFromPointToLineOfUnitVector2DSqr(Vec3 A, Vec3 B, Vec3 v) {
        Vec3 u = A.m_82549_(B.m_82490_(-1.0));
        double dot_u_v = u.m_82526_(v);
        if (dot_u_v < 0.0) {
            return -1.0;
        }
        double dis_sqr = u.m_82556_() - dot_u_v * dot_u_v;
        return dis_sqr;
    }

    public static boolean canPathReachTargetBlock(Dog dog, @Nonnull Path path, BlockPos pos, int maxDY_up, int maxDY_down) {
        Node endNode = path.m_77395_();
        if (endNode == null) {
            return false;
        }
        int dx = endNode.f_77271_ - pos.m_123341_();
        int dz = endNode.f_77273_ - pos.m_123343_();
        int d_sqr = dx * dx + dz * dz;
        int dy = pos.m_123342_() - endNode.f_77272_;
        return d_sqr <= 1 && -maxDY_down <= dy && dy <= maxDY_up;
    }

    public static boolean mayGetPushedIntoHazard(Dog dog, Vec3 pushVec) {
        if (!dog.m_20096_()) {
            return false;
        }
        Vec3 dog_v0 = pushVec;
        Vec3 dog_v01 = new Vec3(dog_v0.f_82479_, 0.0, dog_v0.f_82481_);
        if (dog_v01.f_82479_ == 0.0 && dog_v01.f_82481_ == 0.0) {
            return false;
        }
        Vec3 dog_v1 = dog_v01;
        Vec3 dog_p0 = dog.m_20182_();
        Vec3 dog_p01 = new Vec3(dog_p0.f_82479_ + dog_v1.f_82479_, dog_p0.f_82480_, dog_p0.f_82481_ + dog_v1.f_82481_);
        BlockPos dog_b1 = new BlockPos(Mth.m_14107_((double)dog_p01.f_82479_), Mth.m_14107_((double)dog_p01.f_82480_), Mth.m_14107_((double)dog_p01.f_82481_));
        BlockPathTypes blockType = WalkNodeEvaluator.m_77604_((BlockGetter)dog.f_19853_, (BlockPos.MutableBlockPos)dog_b1.m_122032_());
        if (blockType.getDanger() != null) {
            return true;
        }
        if (blockType != BlockPathTypes.OPEN) {
            return false;
        }
        boolean noWalkable = true;
        for (int i = 1; i <= dog.m_6056_(); ++i) {
            BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)dog.level(), (BlockPos.MutableBlockPos)dog_b1.m_6625_(i).m_122032_());
            if (type == BlockPathTypes.OPEN) continue;
            noWalkable = type != BlockPathTypes.WALKABLE;
            break;
        }
        return noWalkable;
    }

    public static boolean moveToIfReachOrElse(Dog dog, BlockPos pos, double speedModifier, int maxDY_up, int maxDY_down, Consumer<Dog> orElse) {
        Path p = dog.m_21573_().m_7864_(pos, 1);
        if (p == null) {
            orElse.accept(dog);
            return false;
        }
        if (DogUtil.canPathReachTargetBlock(dog, p, pos, maxDY_up, maxDY_down)) {
            dog.m_21573_().m_26536_(p, speedModifier);
            return true;
        }
        orElse.accept(dog);
        return false;
    }

    public static void moveToOwnerOrTeleportIfFarAway(Dog dog, LivingEntity owner, double speedModifier, double distanceToTeleportSqr, boolean continueToMoveWhenTryTp, boolean forceTeleport, double distanceToForceTeleportSqr, int dY) {
        if (owner == null) {
            return;
        }
        double distance = dog.m_20280_((Entity)owner);
        if (!dog.m_21523_() && !dog.m_20159_()) {
            if (distance >= distanceToForceTeleportSqr) {
                if (forceTeleport) {
                    DogUtil.dynamicSearchAndTeleportToOwnwer(dog, owner, 4);
                } else {
                    DogUtil.guessAndTryToTeleportToOwner(dog, owner, 4);
                }
            } else if (distance >= distanceToTeleportSqr) {
                DogUtil.guessAndTryToTeleportToOwner(dog, owner, 4);
                if (continueToMoveWhenTryTp) {
                    dog.m_21573_().m_5624_((Entity)owner, speedModifier);
                }
            } else {
                dog.m_21573_().m_5624_((Entity)owner, speedModifier);
            }
        }
    }

    public static List<Dog> getOtherIncapacitatedDogNearby(Dog dog) {
        int SEARCH_RADIUS = 12;
        List l = dog.f_19853_.m_6443_(Dog.class, dog.m_20191_().m_82377_((double)SEARCH_RADIUS, 2.0, (double)SEARCH_RADIUS), d -> d.isDefeated());
        return l;
    }

    public static void attemptToTeleportDogNearbyOrSendPromise(@Nonnull UUID dogUUID, @Nonnull ServerPlayer owner) {
        Level level = owner.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            Entity e = sLevel.m_8791_(dogUUID);
            if (e != null && e instanceof Dog) {
                Dog d = (Dog)e;
                DogUtil.dynamicSearchAndTeleportToOwnwer(d, (LivingEntity)owner, 4);
            } else {
                DogLocationStorage storage = DogLocationStorage.get((Level)sLevel);
                DogLocationData data = storage.getData(dogUUID);
                if (data == null) {
                    return;
                }
                Vec3 dataPos = data.getPos();
                if (dataPos == null) {
                    return;
                }
                BlockPos pos = new BlockPos(Mth.m_14107_((double)dataPos.f_82479_), Mth.m_14107_((double)dataPos.f_82480_), Mth.m_14107_((double)dataPos.f_82481_));
                DogAsyncTaskManager.addPromiseWithOwner(new DogDistantTeleportToOwnerPromise(dogUUID, (LivingEntity)owner, pos), owner);
            }
        }
    }

    public static void attemptToTeleportDogToBedOrSendPromise(@Nonnull Dog dog) {
        Optional<BlockPos> bedPos = dog.getBedPos();
        if (!bedPos.isPresent()) {
            return;
        }
        ChunkPos chunkpos = new ChunkPos(bedPos.get());
        LivingEntity owner = dog.m_269323_();
        if (dog.f_19853_.m_7232_(chunkpos.f_45578_, chunkpos.f_45579_)) {
            if (DogUtil.isTeleportSafeBlockMidAir(dog, bedPos.get().m_7494_())) {
                DogUtil.teleportInternal(dog, bedPos.get().m_7494_());
            }
        } else if (owner != null && owner instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)owner;
            DogAsyncTaskManager.addPromiseWithOwner(new DogDistantTeleportToBedPromise(dog), sP);
        }
    }

    public static Dog findBiggestDog(List<Dog> dogs) {
        if (dogs.isEmpty()) {
            return null;
        }
        Dog biggest_dog = dogs.get(0);
        for (Dog dog : dogs) {
            if (dog.getDogSize() <= biggest_dog.getDogSize()) continue;
            biggest_dog = dog;
        }
        return biggest_dog;
    }

    public static boolean isSafeBlock() {
        return false;
    }

    private static void teleportInternal(Dog dog, BlockPos target) {
        dog.f_19789_ = 0.0f;
        dog.m_7678_((float)target.m_123341_() + 0.5f, target.m_123342_(), (float)target.m_123343_() + 0.5f, dog.m_146908_(), dog.m_146909_());
        dog.m_21573_().m_26573_();
        dog.breakMoveControl();
    }
}

