/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import java.util.Comparator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class EntityUtil {
    public static double getFollowRange(LivingEntity entityIn) {
        AttributeInstance rangeAttribute = entityIn.m_21051_(Attributes.f_22277_);
        return rangeAttribute == null ? 16.0 : rangeAttribute.m_22135_();
    }

    public static boolean tryToTeleportNearEntity(LivingEntity entityIn, PathNavigation navigator, LivingEntity target, int radius) {
        return EntityUtil.tryToTeleportNearEntity(entityIn, navigator, target.m_20183_(), radius);
    }

    public static boolean tryToTeleportNearEntity(LivingEntity entityIn, PathNavigation navigator, BlockPos targetPos, int radius) {
        for (int i = 0; i < 10; ++i) {
            int j = EntityUtil.getRandomNumber(entityIn, -radius, radius);
            int k = EntityUtil.getRandomNumber(entityIn, -1, 1);
            int l = EntityUtil.getRandomNumber(entityIn, -radius, radius);
            boolean flag = EntityUtil.tryToTeleportToLocation(entityIn, navigator, targetPos, targetPos.m_123341_() + j, targetPos.m_123342_() + k, targetPos.m_123343_() + l);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean tryToTeleportToLocation(LivingEntity entityIn, PathNavigation navigator, BlockPos targetPos, int x, int y, int z) {
        if ((double)Math.abs(x - targetPos.m_123341_()) < 2.0 && (double)Math.abs(z - targetPos.m_123343_()) < 2.0) {
            return false;
        }
        if (!EntityUtil.isTeleportFriendlyBlock(entityIn, new BlockPos(x, y, z), false)) {
            return false;
        }
        entityIn.m_7678_((double)((float)x + 0.5f), (double)y, (double)((float)z + 0.5f), entityIn.m_146908_(), entityIn.m_146909_());
        navigator.m_26573_();
        return true;
    }

    private static boolean isTeleportFriendlyBlock(LivingEntity entityIn, BlockPos pos, boolean teleportToLeaves) {
        BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)entityIn.f_19853_, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathnodetype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = entityIn.f_19853_.m_8055_(pos.m_7495_());
        if (!teleportToLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)entityIn.m_20183_());
        return entityIn.f_19853_.m_45756_((Entity)entityIn, entityIn.m_20191_().m_82338_(blockpos));
    }

    public static int getRandomNumber(LivingEntity entityIn, int minIn, int maxIn) {
        return entityIn.m_217043_().m_188503_(maxIn - minIn + 1) + minIn;
    }

    public static boolean isHolding(@Nullable Entity entity, Item item, Predicate<CompoundTag> nbtPredicate) {
        return EntityUtil.isHolding(entity, (ItemStack stack) -> stack.m_41720_() == item && stack.m_41782_() && nbtPredicate.test(stack.m_41783_()));
    }

    public static boolean isHolding(@Nullable Entity entity, Item item) {
        return EntityUtil.isHolding(entity, (ItemStack stack) -> stack.m_41720_() == item);
    }

    public static boolean isHolding(@Nullable Entity entity, Predicate<ItemStack> matcher) {
        if (entity == null) {
            return false;
        }
        for (ItemStack stack : entity.m_6167_()) {
            if (!matcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Entity> T getClosestTo(Entity center, Iterable<T> entities) {
        return EntityUtil.getClosestTo(center.m_20182_(), entities);
    }

    public static <T extends Entity> T getClosestTo(Vec3 posVec, Iterable<T> entities) {
        double smallestDist = Double.MAX_VALUE;
        Entity closest = null;
        for (Entity entity : entities) {
            double distance = posVec.m_82557_(entity.m_20182_());
            if (!(distance < smallestDist)) continue;
            closest = entity;
            smallestDist = distance;
        }
        return (T)closest;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Vec3 vec3d;

        public Sorter(Entity entityIn) {
            this.vec3d = entityIn.m_20182_();
        }

        public Sorter(Vec3 vec3d) {
            this.vec3d = vec3d;
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            double d0 = this.vec3d.m_82557_(entity1.m_20182_());
            double d1 = this.vec3d.m_82557_(entity2.m_20182_());
            return Double.compare(d0, d1);
        }
    }
}

