/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.doggyasynctask;

import doggytalents.common.util.doggyasynctask.promise.AbstractPromise;
import java.util.ArrayList;
import net.minecraft.server.level.ServerPlayer;

public class DogAsyncTaskManager {
    private static final ArrayList<AbstractPromise> PROMISES = new ArrayList();
    private static final ArrayList<AbstractPromise> TO_REMOVE = new ArrayList();

    public static void tick() {
        if (PROMISES.isEmpty()) {
            return;
        }
        for (AbstractPromise p : PROMISES) {
            switch (p.getState()) {
                case PENDING: {
                    p.setState(AbstractPromise.State.RUNNING);
                    p.start();
                    break;
                }
                case RUNNING: {
                    p.tick();
                    break;
                }
                case FULFILLED: {
                    p.onFulfilled();
                    TO_REMOVE.add(p);
                    break;
                }
                case REJECTED: {
                    p.onRejected();
                    TO_REMOVE.add(p);
                }
            }
        }
        DogAsyncTaskManager.cleanUp();
    }

    public static void cleanUp() {
        if (TO_REMOVE.isEmpty()) {
            return;
        }
        for (AbstractPromise p : TO_REMOVE) {
            p.cleanUp();
            PROMISES.remove(p);
        }
        TO_REMOVE.clear();
    }

    public static void forceStop() {
        for (AbstractPromise p : PROMISES) {
            p.forceReject();
        }
        DogAsyncTaskManager.tick();
    }

    public static void addPromise(AbstractPromise promise) {
        PROMISES.add(promise);
    }

    public static boolean addPromiseWithOwner(AbstractPromise promise, ServerPlayer owner) {
        for (AbstractPromise p : PROMISES) {
            if (p.getOwner() != owner) continue;
            return false;
        }
        promise.setOwner(owner);
        DogAsyncTaskManager.addPromise(promise);
        return true;
    }

    public static boolean addPromiseWithOwnerAndStartImmediately(AbstractPromise promise, ServerPlayer owner) {
        for (AbstractPromise p : PROMISES) {
            if (p.getOwner() != owner) continue;
            return false;
        }
        promise.setOwner(owner);
        DogAsyncTaskManager.addPromise(promise);
        promise.start();
        promise.setState(AbstractPromise.State.RUNNING);
        return true;
    }
}

