/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.doggyasynctask.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.CachedSearchUtil;
import doggytalents.common.util.doggyasynctask.promise.AbstractPromise;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.world.ForgeChunkManager;

public class DogBatchTeleportToDimensionPromise
extends AbstractPromise {
    private final List<Dog> dogs;
    private final UUID playerUUID;
    private final ResourceKey<Level> dimeansion;
    private final ServerLevel origin;
    private int tickTillCheck;
    private int timeOut;
    private final ArrayList<ChunkPos> forcedDogChunk = new ArrayList();

    public DogBatchTeleportToDimensionPromise(List<Dog> dogs, ServerLevel origin, UUID playerUUID, ResourceKey<Level> dimeansion) {
        this.dogs = dogs;
        this.playerUUID = playerUUID;
        this.dimeansion = dimeansion;
        this.origin = origin;
    }

    @Override
    public void start() {
        this.forceDogChunk();
        this.tickTillCheck = 7;
        this.timeOut = 50;
    }

    @Override
    public void tick() {
        if (--this.timeOut <= 0) {
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        if (--this.tickTillCheck > 0) {
            return;
        }
        this.tickTillCheck = 20;
        MinecraftServer mcServer = this.origin.m_7654_();
        ServerLevel targetLevel = mcServer.m_129880_(this.dimeansion);
        if (targetLevel == null) {
            return;
        }
        if (targetLevel == this.origin) {
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        Player owner = targetLevel.m_46003_(this.playerUUID);
        if (owner == null) {
            return;
        }
        BlockPos owner_b0 = owner.m_20183_();
        if (!this.allChunkInvoledAtTargetIsLoaded(targetLevel, owner_b0)) {
            return;
        }
        List<Dog> tp_dogs = this.dogs.stream().filter(d -> d.isDoingFine()).collect(Collectors.toList());
        if (tp_dogs.isEmpty()) {
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        List<BlockPos> safePosList = CachedSearchUtil.getAllSafePosUsingPool((Level)targetLevel, tp_dogs, owner_b0, 4, 1);
        if (safePosList.isEmpty()) {
            return;
        }
        for (Dog dog : tp_dogs) {
            int index = dog.m_217043_().m_188503_(safePosList.size());
            this.teleportDog(dog, targetLevel, safePosList.get(index));
        }
        this.setState(AbstractPromise.State.FULFILLED);
    }

    private boolean allChunkInvoledAtTargetIsLoaded(ServerLevel target, BlockPos ownerPos) {
        ChunkPos center = new ChunkPos(ownerPos);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (target.m_7726_().m_5563_(center.f_45578_ + i, center.f_45579_ + j)) continue;
                return false;
            }
        }
        return true;
    }

    private void teleportDog(Dog dog0, ServerLevel targetLevel, BlockPos pos) {
        if (!dog0.isDoingFine()) {
            return;
        }
        Entity e = dog0.m_6095_().m_20615_((Level)targetLevel);
        if (!(e instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)e;
        dog.m_20361_((Entity)dog0);
        dog.f_19789_ = 0.0f;
        dog.m_7678_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f, dog.m_146908_(), dog.m_146909_());
        dog.m_21573_().m_26573_();
        dog.m_20091_();
        targetLevel.m_143334_((Entity)dog);
        dog0.m_19877_();
        dog0.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        targetLevel.m_8886_();
        Level level = dog0.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            sLevel.m_8886_();
        }
    }

    @Override
    public void onFulfilled() {
    }

    @Override
    public void onRejected() {
    }

    @Override
    public void cleanUp() {
        this.cleanDogChunk();
    }

    private void forceDogChunk() {
        for (Dog dog : this.dogs) {
            ChunkPos chunkpos;
            if (!dog.isDoingFine() || this.forcedDogChunk.contains(chunkpos = new ChunkPos(dog.m_20183_()))) continue;
            this.forcedDogChunk.add(chunkpos);
            ForgeChunkManager.forceChunk((ServerLevel)this.origin, (String)"doggytalents", (UUID)this.getOwner().m_20148_(), (int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (boolean)true, (boolean)true);
        }
    }

    private void cleanDogChunk() {
        for (ChunkPos chunkpos : this.forcedDogChunk) {
            ForgeChunkManager.forceChunk((ServerLevel)this.origin, (String)"doggytalents", (UUID)this.getOwner().m_20148_(), (int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (boolean)false, (boolean)true);
        }
    }
}

