/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.doggyasynctask.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.doggyasynctask.promise.AbstractPromise;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.world.ForgeChunkManager;

public class DogHoldChunkToTeleportPromise
extends AbstractPromise {
    private final List<Dog> dogs;
    private final ServerLevel level;
    private int timeOut;
    private final ArrayList<ChunkPos> forcedDogChunk = new ArrayList();

    public DogHoldChunkToTeleportPromise(List<Dog> dogs, ServerLevel level) {
        this.dogs = dogs;
        this.level = level;
    }

    @Override
    public void start() {
        this.forceDogChunk();
        this.timeOut = 40;
    }

    @Override
    public void tick() {
        if (--this.timeOut <= 0) {
            this.setState(AbstractPromise.State.FULFILLED);
            return;
        }
    }

    @Override
    public void onFulfilled() {
    }

    @Override
    public void onRejected() {
    }

    @Override
    public void cleanUp() {
        this.cleanDogChunk();
    }

    private void forceDogChunk() {
        for (Dog dog : this.dogs) {
            ChunkPos chunkpos;
            if (!dog.isDoingFine() || this.forcedDogChunk.contains(chunkpos = new ChunkPos(dog.m_20183_()))) continue;
            this.forcedDogChunk.add(chunkpos);
            ForgeChunkManager.forceChunk((ServerLevel)this.level, (String)"doggytalents", (UUID)this.getOwner().m_20148_(), (int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (boolean)true, (boolean)true);
        }
    }

    private void cleanDogChunk() {
        for (ChunkPos chunkpos : this.forcedDogChunk) {
            ForgeChunkManager.forceChunk((ServerLevel)this.level, (String)"doggytalents", (UUID)this.getOwner().m_20148_(), (int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (boolean)false, (boolean)true);
        }
        this.forcedDogChunk.clear();
    }
}

