/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.client.scanner;

import com.klikli_dev.theurgy.client.scanner.Scanner;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class ScanManager {
    private static final ScanManager instance = new ScanManager();
    List<BlockPos> results = new ArrayList<BlockPos>();
    private Scanner scanner;
    private int scanningTicks = -1;

    public static ScanManager get() {
        return instance;
    }

    public void beginScan(Player player, Set<Block> targets, int range, int duration) {
        this.cancelScan();
        this.scanner = new Scanner(targets);
        this.scanner.initialize(player, player.m_20182_(), range, duration);
    }

    public void updateScan(Player player, boolean forceFinish) {
        if (this.scanner == null) {
            return;
        }
        int remainingTicks = this.scanner.totalTicks - this.scanningTicks;
        if (remainingTicks <= 0) {
            return;
        }
        if (!forceFinish) {
            this.scanner.scan(result -> this.results.add((BlockPos)result));
            ++this.scanningTicks;
            return;
        }
        for (int i = 0; i < remainingTicks; ++i) {
            this.scanner.scan(result -> this.results.add((BlockPos)result));
            ++this.scanningTicks;
        }
    }

    public BlockPos finishScan(Player player) {
        this.updateScan(player, true);
        Vec3 scanCenter = player.m_20182_();
        this.results.sort(Comparator.comparing(result -> result.m_203193_((Position)scanCenter)));
        BlockPos result2 = !this.results.isEmpty() ? this.results.get(0) : null;
        this.cancelScan();
        return result2;
    }

    public void cancelScan() {
        this.scanner = null;
        this.results.clear();
        this.scanningTicks = -1;
    }
}

