/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.config.ServerConfig;
import com.klikli_dev.theurgy.registry.RecipeRegistry;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class DivinationRodRecipe
extends ShapedRecipe {
    public DivinationRodRecipe(ResourceLocation pId, String pGroup, int pWidth, int pHeight, NonNullList<Ingredient> pRecipeItems, ItemStack pResult) {
        super(pId, pGroup, CraftingBookCategory.MISC, pWidth, pHeight, pRecipeItems, pResult);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.DIVINATION_ROD.get();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        ItemStack result = super.m_8043_(registryAccess);
        CompoundTag resultTag = result.m_41784_();
        if (!resultTag.m_128441_("theurgy:divination.linked_block_id")) {
            ResourceLocation sourceId = null;
            for (Ingredient ingredient : this.m_7527_()) {
                CompoundTag ingredientTag;
                JsonObject jsonObj;
                JsonElement json = ingredient.m_43942_();
                if (!(json instanceof JsonObject) || !(jsonObj = (JsonObject)json).has("nbt") || !(ingredientTag = CraftingHelper.getNBT((JsonElement)jsonObj.get("nbt"))).m_128441_("theurgy:sulfur.source.id")) continue;
                sourceId = new ResourceLocation(ingredientTag.m_128461_("theurgy:sulfur.source.id"));
                break;
            }
            if (sourceId != null) {
                ResourceLocation translated = this.translateToBlock(sourceId);
                if (translated != null) {
                    resultTag.m_128359_("theurgy:divination.linked_block_id", translated.toString());
                } else {
                    resultTag.m_128359_("theurgy:divination.linked_block_id", sourceId.toString());
                }
                resultTag.m_128379_("theurgy:divination.linked_block_id.preview_mode", true);
            }
        }
        return result;
    }

    public ItemStack m_5874_(CraftingContainer pInv, RegistryAccess registryAccess) {
        ItemStack result = this.m_8043_(registryAccess).m_41777_();
        CompoundTag resultTag = result.m_41784_();
        if (!resultTag.m_128441_("theurgy:divination.linked_block_id") || resultTag.m_128471_("theurgy:divination.linked_block_id.preview_mode")) {
            ResourceLocation sourceId = null;
            for (int i = 0; i < pInv.m_6643_(); ++i) {
                CompoundTag tag;
                ItemStack stack = pInv.m_8020_(i);
                if (!stack.m_41782_() || !(tag = stack.m_41783_()).m_128441_("theurgy:sulfur.source.id")) continue;
                sourceId = new ResourceLocation(tag.m_128461_("theurgy:sulfur.source.id"));
                break;
            }
            if (sourceId != null) {
                ResourceLocation translated = this.translateToBlock(sourceId);
                if (translated != null) {
                    resultTag.m_128359_("theurgy:divination.linked_block_id", translated.toString());
                } else {
                    resultTag.m_128359_("theurgy:divination.linked_block_id", sourceId.toString());
                }
            }
        }
        return super.m_5874_(pInv, registryAccess);
    }

    public ResourceLocation translateToBlock(ResourceLocation sourceId) {
        Optional<ResourceLocation> fallback;
        String mapped = (String)((Map)ServerConfig.get().recipes.sulfurSourceToBlockMapping.get()).get(sourceId.toString());
        if (mapped != null) {
            return new ResourceLocation(mapped);
        }
        String path = sourceId.m_135815_();
        Object translatedPath = path;
        if (path.contains("raw_")) {
            translatedPath = path.replace("raw_", "");
        } else if (path.contains("_nugget")) {
            translatedPath = path.replace("_nugget", "");
        } else if (path.contains("_ingot")) {
            translatedPath = path.replace("_ingot", "");
        } else if (path.contains("_ore")) {
            translatedPath = path.replace("_ore", "");
            if (path.contains("deepslate_")) {
                translatedPath = ((String)translatedPath).replace("deepslate_", "");
            }
        } else if (path.contains("_dust")) {
            translatedPath = path.replace("_dust", "");
        } else if (path.contains("_block")) {
            translatedPath = path.replace("_block", "");
        }
        translatedPath = (String)translatedPath + "_ore";
        ResourceLocation translated = new ResourceLocation(sourceId.m_135827_(), (String)translatedPath);
        if (ForgeRegistries.BLOCKS.containsKey(translated)) {
            return translated;
        }
        if (!ForgeRegistries.BLOCKS.containsKey(translated) && (fallback = ForgeRegistries.BLOCKS.getKeys().stream().filter(x -> x.m_135815_().equals(translated.m_135815_())).findFirst()).isPresent()) {
            return fallback.get();
        }
        Theurgy.LOGGER.warn("Could not find an appropriate block for sulfur source id: " + sourceId + ", tried path: " + (String)translatedPath);
        return null;
    }

    public static class Serializer
    implements RecipeSerializer<DivinationRodRecipe> {
        public DivinationRodRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(pRecipeId, pJson);
            return new DivinationRodRecipe(pRecipeId, shapedRecipe.m_6076_(), shapedRecipe.m_44220_(), shapedRecipe.m_44221_(), (NonNullList<Ingredient>)shapedRecipe.m_7527_(), shapedRecipe.m_8043_(null));
        }

        public DivinationRodRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(pRecipeId, pBuffer);
            return new DivinationRodRecipe(pRecipeId, shapedRecipe.m_6076_(), shapedRecipe.m_44220_(), shapedRecipe.m_44221_(), (NonNullList<Ingredient>)shapedRecipe.m_7527_(), shapedRecipe.m_8043_(null));
        }

        public void toNetwork(FriendlyByteBuf pBuffer, DivinationRodRecipe pRecipe) {
            RecipeSerializer.f_44076_.m_6178_(pBuffer, (Recipe)pRecipe);
        }
    }
}

